<?php
/**
 * Plugin Name: YayMail Pro - WooCommerce Email Customizer
 * Plugin URI: https://yaycommerce.com/yaymail-woocommerce-email-customizer/
 * Description: Create awesome transactional emails with a drag and drop email builder
 * Version: 4.0.4
 * Author: YayCommerce
 * Author URI: https://yaycommerce.com
 * Text Domain: yaymail
 * WC requires at least: 3.0.0
 * WC tested up to: 9.9
 * Domain Path: /i18n/languages/
 *
 * @package YayMail
 */

namespace YayMail;

defined( 'ABSPATH' ) || exit;

add_filter('pre_http_request', function($preempt, $parsed_args, $url) {
    if ($parsed_args['method'] === 'GET' && strpos($url, 'https://yaycommerce.com/') !== false) {

        $response = array(
            "headers" => array(),
            "body" => json_encode(array(
                "success" => true,
                "license" => "valid",
                "item_id" => "4216",
                "item_name" => "YayMail Pro – WooCommerce Email Customizer",
                "license_limit" => 10,
                "site_count" => 1,
                "expires" => "lifetime",
                "activations_left" => 9,
                "checksum" => "B5E0B5F8DD8689E6ACA49DD6E6E1A930",
                "payment_id" => 123321,
                "customer_name" => "GPL",
                "customer_email" => "noreply@gmail.com",
                "price_id" => "1"
            )),
            "response" => array(
                "code" => 200,
                "message" => "OK"
            )
        );

        return $response;
    }

    return $preempt;
}, 10, 3);

if ( ! defined( 'YAYMAIL_PREFIX' ) ) {
    define( 'YAYMAIL_PREFIX', 'yaymail' );
}

if ( ! defined( 'YAYMAIL_DEBUG' ) ) {
    define( 'YAYMAIL_DEBUG', false );
}

if ( ! defined( 'YAYMAIL_VERSION' ) ) {
    define( 'YAYMAIL_VERSION', '4.0.4' );
}

if ( ! defined( 'YAYMAIL_PLUGIN_URL' ) ) {
    define( 'YAYMAIL_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
}

if ( ! defined( 'YAYMAIL_PLUGIN_PATH' ) ) {
    define( 'YAYMAIL_PLUGIN_PATH', plugin_dir_path( __FILE__ ) );
}

if ( ! defined( 'YAYMAIL_PLUGIN_BASENAME' ) ) {
    define( 'YAYMAIL_PLUGIN_BASENAME', plugin_basename( __FILE__ ) );
}

if ( ! defined( 'YAYMAIL_IS_DEVELOPMENT' ) ) {
    define( 'YAYMAIL_IS_DEVELOPMENT', false );
}

if ( ! defined( 'YAYMAIL_REST_NAMESPACE' ) ) {
    define( 'YAYMAIL_REST_NAMESPACE', 'yaymail/v1' );
}

$yaymail_has_required_deps = true;
if ( function_exists( 'YayMail\\init' ) ) {
    require_once plugin_dir_path( __FILE__ ) . 'templates/fallbacks/fallback-exists.php';
    $yaymail_has_required_deps = false;
}

if ( version_compare( PHP_VERSION, '7.2', '<' ) ) {
    require_once plugin_dir_path( __FILE__ ) . 'templates/fallbacks/fallback-minimum-php.php';
    $yaymail_has_required_deps = false;
}

if ( version_compare( $GLOBALS['wp_version'], '5.2', '<' ) ) {
    require_once plugin_dir_path( __FILE__ ) . 'templates/fallbacks/fallback-minimum-wp.php';
    $yaymail_has_required_deps = false;
}

if ( ! $yaymail_has_required_deps ) {
    add_action(
        'admin_init',
        function() {
            deactivate_plugins( plugin_basename( __FILE__ ) );
        }
    );

    // Return early to prevent loading the plugin.
    return;
}

require_once YAYMAIL_PLUGIN_PATH . 'vendor/autoload.php';

/**
 * Initialize constants
 */
Constants\ConstantsHandler::get_instance();

if ( ! function_exists( 'install_yaymail_admin_notice' ) ) {
    function install_yaymail_admin_notice() {
        ?>
            <div class="error">          
                <p>
                <?php
                // translators: %s: search WooCommerce plugin link
                printf( 'YayMail ' . esc_html__( 'is enabled but not effective. It requires %1$sWooCommerce%2$s in order to work.', 'yaymail' ), '<a href="' . esc_url( admin_url( 'plugin-install.php?s=woocommerce&tab=search&type=term' ) ) . '">', '</a>' );
                ?>
                </p>
            </div>
        <?php
    }
}

if ( ! function_exists( 'YayMail\\init' ) ) {
    function init() {
        \YayMail\YayCommerceMenu\RegisterMenu::get_instance();
        \YayMail\License\LicenseHandler::get_instance();
        if ( ! function_exists( 'WC' ) ) {
            add_action( 'admin_notices', 'YayMail\\install_yaymail_admin_notice' );
        } else {
            add_action( 'before_woocommerce_init', 'YayMail\\yaymail_enable_compatible_hpos' );
            do_action( 'yaymail_before_init' );

            \YayMail\Initialize::get_instance();
        }
    }
}

if ( ! function_exists( 'yaymail_enable_compatible_hpos' ) ) {
    function yaymail_enable_compatible_hpos() {
        if ( class_exists( \Automattic\WooCommerce\Utilities\FeaturesUtil::class ) ) {
            \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'custom_order_tables', __FILE__, true );

            // Set compatible for addon
            $plugins = get_plugins();
            foreach ( array_keys( $plugins ) as $key ) {
                $is_yaymail_addon = strpos( $key, 'yaymail-addon' ) !== false || strpos( $key, 'email-customizer' ) !== false;
                if ( $is_yaymail_addon ) {
                    \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'custom_order_tables', $key, true );
                }
            }
        }
    }
}

if ( ! wp_installing() ) {
    add_action( 'plugins_loaded', 'YayMail\\init' );
}

register_activation_hook( __FILE__, [ \YayMail\Engine\ActDeact::class, 'activate' ] );
register_deactivation_hook( __FILE__, [ \YayMail\Engine\ActDeact::class, 'deactivate' ] );

if ( ! function_exists( 'YayMail\\on_update' ) ) {
    function on_update( $upgrader_object, $options ) {
        // The path to our plugin's main file
        $our_plugin = plugin_basename( __FILE__ );
        // If an update has taken place and the updated type is plugins and the plugins element exists
        if ( $options['action'] === 'update' && $options['type'] === 'plugin' && isset( $options['plugins'] ) ) {
            if ( in_array( $our_plugin, $options['plugins'], true ) ) {
                \YayMail\Migrations\MainMigration::get_instance()->migrate();
            }
        }
    }
}
add_action( 'upgrader_process_complete', 'YayMail\\on_update', 10, 2 );
