<?php

namespace YayMailAddonConditionalLogic\Services;

use YayMailAddonConditionalLogic\SingletonTrait;
defined( 'ABSPATH' ) || exit;

/**
 * RestApiService Class
 *
 * @method static RestApiService get_instance()
 */
class RestApiService {
    use SingletonTrait;

    public function get_page( $entity = 'product_skus', $params = [] ) {
        global $wpdb;

        $page_num      = $params['page_num'] ?? 1;
        $page_size     = $params['page_size'] ?? 20;
        $search_string = $params['search_string'] ?? '';

        // +1 in order to check for next_page
        $limit  = $page_size + 1;
        $offset = ( $page_num - 1 ) * $page_size;

        $query = $this->get_query( $entity, $limit, $offset, $search_string );
        if ( empty( $query ) ) {
            throw new \Exception( 'Get query failed', 500 );
        }

        $list = $wpdb->get_results( $query );

        $next_page = count( $list ) > $page_size ? $page_num + 1 : false;

        if ( $next_page ) {
            array_pop( $list );
        }

        $result = [
            'list'      => $list,
            'next_page' => $next_page,
        ];

        return $result;
    }

    private function get_query( $entity, $limit, $offset, $search_string ) {
        global $wpdb;

        $search_like = '%' . $wpdb->esc_like( $search_string ) . '%';
        $queries     = [
            'product_skus' => $wpdb->prepare(
                "SELECT 
                    DISTINCT(pm.meta_value) AS id,
                    pm.meta_value AS name
                FROM {$wpdb->prefix}postmeta AS pm 
                    INNER JOIN {$wpdb->prefix}posts AS p
                    ON pm.post_id = p.ID
                WHERE pm.meta_key = '_sku'
                    AND p.post_type IN ('product', 'product_variation')
                    AND p.post_status = 'publish'
                    AND (p.post_title LIKE %s OR pm.meta_value LIKE %s)
                ORDER BY pm.meta_value ASC 
                LIMIT %d OFFSET %d",
                $search_like,
                $search_like,
                $limit,
                $offset
            ),

            'coupon_codes' => $wpdb->prepare(
                "SELECT post_name AS id, post_name AS name
                FROM {$wpdb->prefix}posts
                WHERE post_type = 'shop_coupon' 
                    AND post_status = 'publish'
                    AND (post_title LIKE %s OR post_name LIKE %s)
                ORDER BY post_name ASC 
                LIMIT %d OFFSET %d",
                $search_like,
                $search_like,
                $limit,
                $offset
            ),
        ];

        return $queries[ $entity ];
    }
}
