<?php

namespace YayMailAddonConditionalLogic\Migrations\Versions;

use YayMailAddonConditionalLogic\SingletonTrait;
use YayMail\Migrations\AbstractMigration;

/**
 * Conditional_Logic_Ver_3_0_0::get_instance()
 */
final class Conditional_Logic_Ver_3_0_0 extends AbstractMigration {
    use SingletonTrait;

    private function __construct() {
        parent::__construct( '2.9.9', '4.0', 'YayMailAddonConditionalLogic' );
    }

    protected function up() {
        global $wpdb;
        $template_posts_query = "
            SELECT * 
            FROM {$wpdb->posts}
            WHERE post_type = 'yaymail_template' AND post_status IN ('publish', 'pending', 'future')
        ";
        $template_posts       = $wpdb->get_results( $template_posts_query );
        if ( empty( $template_posts ) ) {
            $this->logger->log( 'There is no template to be migrated' );
            return;
        }
        foreach ( $template_posts as $template ) {
            $template_id = $template->ID;
            $elements    = get_post_meta( $template_id, '_yaymail_elements', true );

            $this->migrate_elements( $elements, $template );

            update_post_meta( $template_id, '_yaymail_elements', $elements );
        }

        update_option( 'yaymail_conditional_logic_is_v4_supported', true );
    }

    private function migrate_elements( &$elements, $template ) {
        foreach ( $elements as &$element ) {
            $setting_row = $element['settingRow'] ?? null;

            // Skip if `arrConditionLogic` is not set or empty
            if ( empty( $setting_row['arrConditionLogic'] ) || ! is_array( $setting_row['arrConditionLogic'] ) ) {
                continue;
            }

            // Set conditional logic bulk operator if available
            if ( isset( $setting_row['conditionType'] ) ) {
                $element['data']['conditional_logic_bulk_operator'] = $setting_row['conditionType'];
            }

            // Migrate old conditional logic to new format
            $conditional_logics = array_map( [ $this, 'get_new_conditional_logic' ], $setting_row['arrConditionLogic'] );

            // Assign the new conditional logics
            $element['data']['conditional_logic'] = $conditional_logics;
        }
    }

    private function get_new_conditional_logic( array $old_logic ): array {
        $new_logic_value = $old_logic['value'];
        if ( 'products' === $old_logic['logic'] || 'product_categories' === $old_logic['logic'] || 'product_skus' === $old_logic['logic'] || 'coupon_codes' === $old_logic['logic'] ) {
            $transformed_values = [];
            foreach ( $new_logic_value as $key => $value ) {
                if ( is_array( $value ) ) {
                    $transformed_values[ $key ] = [
                        'value' => $value['id'],
                        'label' => $value['name'],
                    ];
                } else {
                    $transformed_values[ $key ] = [
                        'value' => $value,
                        'label' => 'product_categories' === $old_logic['logic'] ? $this->get_product_category_label( $value ) : $value,
                    ];
                }
            }
            $new_logic_value = $transformed_values;
        }
        return [
            'comparing_operator' => $old_logic['comparingOperator'] ?? 'is',
            'logic'              => $old_logic['logic'],
            'name'               => $old_logic['name'],
            'value'              => $new_logic_value,
            'key'                => uniqid(),
        ];
    }

    private function get_product_category_label( $cat_id ) {
        $cat = get_term_by( 'id', $cat_id, 'product_cat' );
        return $cat->name;
    }
}
