<?php
namespace YayMailAddonConditionalLogic\Migrations;

use YayMail\Migrations\AbstractAddonMigrationManager;
use YayMailAddonConditionalLogic\SingletonTrait;
use YayMail\Migrations\MigrationHelper;


/**
 * Database migration for YayMail Addon Conditional Logic
 */
class ConditionalLogicMigration extends AbstractAddonMigrationManager {
    use SingletonTrait;

    protected function __construct() {
        $this->default_legacy_version = '2.9.9';
        $addon_versions               = get_option( 'yaymail_addon_versions' );
        $old_version                  = MigrationHelper::format_version_number( $addon_versions['YayMailAddonConditionalLogic'] ?? $this->default_legacy_version );

        parent::__construct( $old_version, YAYMAIL_ADDON_CONDITIONAL_LOGIC_VERSION, 'YayMailAddonConditionalLogic', __( 'YayMail Conditional Logic', 'yaymail' ) );
    }

    protected function declare_migrations() {
        $this->addon_migrations = [ '4.0' => 'YayMailAddonConditionalLogic\Migrations\Versions\Conditional_Logic_Ver_3_0_0' ];
    }

    public function is_v4_supported() {
        return get_option( 'yaymail_conditional_logic_is_v4_supported', false );
    }

    protected function filter_migrations_by_v4_supported_status(): void {
        $this->filter_migrations_by_version_threshold( '4.0' );
    }

    public static function check_and_save_v4_support_status() {
        global $wpdb;
        $template_posts_query = "
            SELECT * 
            FROM {$wpdb->posts}
            WHERE post_type = 'yaymail_template' AND post_status IN ('publish', 'pending', 'future')
        ";

        $template_posts = $wpdb->get_results( $template_posts_query );
        if ( empty( $template_posts ) ) {
            add_option( 'yaymail_conditional_logic_is_v4_supported', true );
            return;
        }

        foreach ( $template_posts as $template ) {
            $template_id = $template->ID;
            $elements    = get_post_meta( $template_id, '_yaymail_elements', true );

            foreach ( $elements as $element ) {
                if ( ! empty( $element['settingRow']['arrConditionLogic'] ) ) {
                    return;
                }
            }
        }
        add_option( 'yaymail_conditional_logic_is_v4_supported', true );
    }
}
