<?php
namespace YayMailAddonConditionalLogic;

/**
 * License for addon
 */
class License {
    use SingletonTrait;

    public function __construct() {
        add_filter( 'yaymail_available_licensing_plugins', [ $this, 'yaymail_addon_license' ] );
    }

    public static function yaymail_addon_license( $plugins ) {
        $plugin_data    = [
            'Name'       => 'YayMail Addon for Conditional Logic',
            'Version'    => YAYMAIL_ADDON_CONDITIONAL_LOGIC_VERSION,
            'AuthorName' => 'YayCommerce',
        ];
        $plugin_version = $plugin_data['Version'];
        $plugin_name    = $plugin_data['Name'];
        $plugin_slug    = strtolower( str_replace( ' ', '_', $plugin_name ) );
        $plugins[]      = [
            'name'     => $plugin_name,
            'slug'     => $plugin_slug,
            'dir_path' => YAYMAIL_ADDON_CONDITIONAL_LOGIC_PLUGIN_PATH,
            'basename' => YAYMAIL_ADDON_CONDITIONAL_LOGIC_BASE_NAME,
            'url'      => YAYMAIL_ADDON_CONDITIONAL_LOGIC_PLUGIN_URL,
            'file'     => YAYMAIL_ADDON_CONDITIONAL_LOGIC_PLUGIN_FILE,
            'version'  => $plugin_version,
            'item_id'  => '8236',
        ];
        return $plugins;
    }
}
