<?php

namespace YayMailAddonConditionalLogic\Integrations;

use YayMailAddonConditionalLogic\SingletonTrait;

/**
 * YithGiftCardPremiumIntegration Class
 *
 * @method static YithGiftCardPremiumIntegration get_instance()
 */
class YithGiftCardPremiumIntegration {
    use SingletonTrait;

    protected function __construct() {

        if ( ! function_exists( 'yith_ywgc_premium_init' ) ) {
            return;
        }

        add_filter( 'yaymail_conditional_logic_prepared_wc_email_args', [ $this, 'change_email_args' ], 10 );
    }

    public function change_email_args( $wc_email_args ) {

        if ( ! isset( $wc_email_args['gift_card'] ) || ! ( $wc_email_args['gift_card'] instanceof \YWGC_Gift_Card_Premium ) ) {
            return $wc_email_args;
        }
        try {
            $wc_email_args['order'] = wc_get_order( $wc_email_args['gift_card']->order_id );
        } catch ( \Error $error ) {
            return $wc_email_args;
        }

        return $wc_email_args;

    }

}
