<?php

namespace YayMailAddonConditionalLogic\Integrations;

use YayMailAddonConditionalLogic\SingletonTrait;

/**
 * BookingIntegration Class
 *
 * @method static BookingIntegration get_instance()
 */
class BookingIntegration {
    use SingletonTrait;

    protected function __construct() {

        add_filter( 'yaymail_conditional_logic_prepared_wc_email_args', [ $this, 'change_email_args' ], 10 );
    }

    public function change_email_args( $wc_email_args ) {

        $booking = $wc_email_args['booking'] ?? null;

        if ( ! $booking ) {
            return $wc_email_args;
        }

        // If booking exists, get the order from the booking
        try {
            $order                  = wc_get_order( $booking->get_order_id() );
            $wc_email_args['order'] = $order;
        } catch ( \Error $error ) {
            return $wc_email_args;
        }

        return $wc_email_args;

    }

}
