<?php

namespace YayMailAddonConditionalLogic\Engine;

use YayMailAddonConditionalLogic\Migrations\ConditionalLogicMigration;
use YayMailAddonConditionalLogic\SingletonTrait;
use YayMail\Migrations\MainMigration;
/**
 * Activate and deactive method of the plugin and relates.
 */
class ActDeact {
    use SingletonTrait;

    protected function __construct() {}

    public static function activate() {
        if ( ! function_exists( 'YayMail\\init' ) || version_compare( YAYMAIL_VERSION, '4.0', '<' ) ) {
            return;
        }
        ConditionalLogicMigration::check_and_save_v4_support_status();
        if ( class_exists( 'YayMail\Migrations\AbstractAddonMigrationManager' ) ) {
            \YayMailAddonConditionalLogic\Migrations\ConditionalLogicMigration::get_instance();
            MainMigration::get_instance()->migrate();
        }
    }
    public static function deactivate() {
    }
}
