<?php

namespace YayMailAddonConditionalLogic\Controllers;

use YayMail\Abstracts\BaseController;
use YayMail\Utils\SingletonTrait;
use YayMailAddonConditionalLogic\Services\RestApiService;

/**
 * ConditionalLogic's RestController
 *
 * @method static ConditionalLogic's RestController get_instance()
 */
class RestController extends BaseController {
    use SingletonTrait;

    private $service;

    protected function __construct() {
        $this->service = RestApiService::get_instance();
        $this->init_hooks();
    }

    protected function init_hooks() {
        register_rest_route(
            YAYMAIL_REST_NAMESPACE,
            '/conditional-logic/product-skus',
            [
                [
                    'methods'             => \WP_REST_Server::READABLE,
                    'callback'            => [ $this, 'exec_get_product_skus' ],
                    'permission_callback' => [ $this, 'permission_callback' ],
                ],
            ]
        );
        register_rest_route(
            YAYMAIL_REST_NAMESPACE,
            '/conditional-logic/coupon-codes',
            [
                [
                    'methods'             => \WP_REST_Server::READABLE,
                    'callback'            => [ $this, 'exec_get_coupon_codes' ],
                    'permission_callback' => [ $this, 'permission_callback' ],
                ],
            ]
        );
    }

    /**
     * Handle get product skus
     */
    public function exec_get_product_skus( \WP_REST_Request $request ) {
        return $this->exec( [ $this, 'get_product_skus' ], $request );
    }
    public function get_product_skus( \WP_REST_Request $request ) {
        $params['search_string'] = sanitize_text_field( $request->get_param( 'search_string' ) );
        $params['page_num']      = sanitize_text_field( $request->get_param( 'page_num' ) );
        $params['page_size']     = sanitize_text_field( $request->get_param( 'page_size' ) );
        $result                  = $this->service->get_page( 'product_skus', $params );

        return $result;
    }

    /**
     * Handle get coupon codes
     */
    public function exec_get_coupon_codes( \WP_REST_Request $request ) {
        return $this->exec( [ $this, 'get_coupon_codes' ], $request );
    }
    public function get_coupon_codes( \WP_REST_Request $request ) {
        $params['search_string'] = sanitize_text_field( $request->get_param( 'search_string' ) );
        $params['page_num']      = sanitize_text_field( $request->get_param( 'page_num' ) );
        $params['page_size']     = sanitize_text_field( $request->get_param( 'page_size' ) );
        $result                  = $this->service->get_page( 'coupon_codes', $params );

        return $result;
    }
}
