<?php
namespace YayMailAddonConditionalLogic\Controllers;

use YayMail\Models\ProductModel;
use YayMailAddonConditionalLogic\Services\RestApiService;

/**
 * Localize addon's required variables
 */
class AddonLocalizeSettingsController {
    protected static $instance = null;

    protected $product_model;

    protected $rest_api_service;

    public static function get_instance() {
        if ( self::$instance === null ) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    private function __construct() {
        $this->product_model    = ProductModel::get_instance();
        $this->rest_api_service = RestApiService::get_instance();
        $this->do_hooks();
    }

    private function do_hooks() {
        add_filter( 'yaymail_additional_localized_variables', [ $this, 'add_conditional_logic_variables' ] );
    }

    public function add_conditional_logic_variables( $vars ) {
        $first_paged_product_categories = $this->product_model->get_terms( [ 'term_type' => 'product_cat' ] );
        $first_paged_products           = $this->product_model->get_terms( [ 'term_type' => null ] );
        // Default is for products
        $first_paged_product_skus  = $this->rest_api_service->get_page( 'product_skus' );
        $available_payment_methods = array_map(
            function( $method ) {
                return [
                    'id'   => $method->id,
                    'name' => $method->get_title(),
                ];
            },
            array_values( WC()->payment_gateways->get_available_payment_gateways() )
        );

        $available_shipping_methods = array_map(
            function( $method ) {
                return [
                    'id'   => $method->id,
                    'name' => $method->get_method_title(),
                ];
            },
            array_values(
                array_filter(
                    WC()->shipping->get_shipping_methods(),
                    function( $method ) {
                        return $method->id !== 'pickup_location';
                    }
                )
            )
        );

        $first_paged_coupon_codes = $this->rest_api_service->get_page( 'coupon_codes' );
        $booking_payment_statuses = [
            [
                'id'   => 'pending',
                'name' => __( 'Pending payment', 'yaymail' ),
            ],
            [
                'id'   => 'processing',
                'name' => __( 'Processing', 'yaymail' ),
            ],
        ];

        $vars['conditional_logic'] = [
            'billing_countries'              => WC()->countries->countries,
            'first_paged_product_categories' => $first_paged_product_categories,
            'first_paged_products'           => $first_paged_products,
            'first_paged_product_skus'       => $first_paged_product_skus,
            'payment_methods'                => $available_payment_methods,
            'shipping_methods'               => $available_shipping_methods,
            'first_paged_coupon_codes'       => $first_paged_coupon_codes,
            'booking_payment_statuses'       => $booking_payment_statuses,
        ];
        return $vars;
    }
}
