<?php

namespace YayMailAddonConditionalLogic\Controllers;

use YayMailAddonConditionalLogic\Services\ConditionalLogicService;

defined( 'ABSPATH' ) || exit;

/**
 * AddonController Class
 *
 * @method static AddonController get_instance()
 */
class AddonController {
    protected static $instance;

    /**
     * @var ConditionalLogicService $service Instance of the ConditinalLogicService
     */
    protected $service;

    private function __construct() {
        $this->service = ConditionalLogicService::get_instance();
    }

    public static function get_instance() {
        if ( null == self::$instance ) {
            self::$instance = new self();
            self::$instance->do_hooks();
        }

        return self::$instance;
    }

    private function do_hooks() {
        add_filter( 'yaymail_extra_element_attributes', [ $this, 'add_conditional_logic_builder_to_element' ] );

        add_filter( 'yaymail_validate_element_before_sending', [ $this, 'check_element_before_sending_email' ], 10, 3 );
    }

    public function add_conditional_logic_builder_to_element( $extra_attributes ) {
        $conditional_logic_attribute = [
            'component' => 'addon_conditional_logic_builder',
        ];

        $extra_attributes['conditional_logic'] = $conditional_logic_attribute;

        return $extra_attributes;
    }

    public function check_element_before_sending_email( $check, $element, $args ) {

        if ( empty( $element['data']['conditional_logic'] ) ) {
            return $check;
        }

        if ( empty( $args['render_data'] ) ) {
            return $check;
        }

        return $this->service->meets_conditional_logics( $element['data']['conditional_logic'], $element['data']['conditional_logic_bulk_operator'] ?? 'all', $args['render_data'] );
    }
}
