<?php

namespace YayMailAddonB2BKing\Shortcodes\Renderers;

use YayMail\Utils\TemplateHelpers;

/**
 * @method: static B2BKingOfferProducts get_instance()
 */
class B2BKingOfferProductsRenderer {

    public $element_data = null;

    public $is_placeholder = false;

    public $titles = [];

    private $offerid = null;

    private $sample_offer = [];


    public function __construct( $offerid, $element_data, $is_placeholder ) {
        $this->element_data   = $element_data;
        $this->is_placeholder = $is_placeholder;
        $this->initialize_titles();

        if ( empty( $offerid ) ) {
            $this->initialize_sample_data();
        } else {
            $this->offerid = $offerid;
        }
    }

    public function initialize_titles() {
        $this->titles = [
            'product'  => $this->element_data['product_title'] ?? TemplateHelpers::get_content_as_placeholder( 'product_title', esc_html__( 'Product', 'b2bking' ), $this->is_placeholder ),
            'quantity' => $this->element_data['quantity_title'] ?? TemplateHelpers::get_content_as_placeholder( 'quantity_title', esc_html__( 'Quantity', 'b2bking' ), $this->is_placeholder ),
            'price'    => $this->element_data['price_title'] ?? TemplateHelpers::get_content_as_placeholder( 'price_title', esc_html__( 'Price', 'b2bking' ), $this->is_placeholder ),
            'total'    => $this->element_data['total_title'] ?? TemplateHelpers::get_content_as_placeholder( 'total_title', esc_html__( 'Total', 'b2bking' ), $this->is_placeholder ),
        ];
    }

    private function initialize_sample_data() {
        $this->sample_offer = [
            'product'  => __( 'Happy YayCommerce', 'yaymail' ),
            'quantity' => 1,
            'price'    => wc_price( 100 ),
            'total'    => wc_price( 100 ),
        ];
    }

    public function get_styles() {
        return TemplateHelpers::get_style(
            [
                'padding'      => '12px',
                'font-size'    => '14px',
                'text-align'   => yaymail_get_text_align(),
                'font-family'  => TemplateHelpers::get_font_family_value( isset( $this->element_data['font_family'] ) ? $this->element_data['font_family'] : 'inherit' ),
                'color'        => isset( $this->element_data['text_color'] ) ? $this->element_data['text_color'] : 'inherit',
                'border-width' => '1px',
                'border-style' => 'solid',
                'border-color' => isset( $this->element_data['border_color'] ) ? $this->element_data['border_color'] : 'inherit',
            ]
        );
    }

    public function render() {
        $style       = $this->get_styles();
        $table_style = $this->get_styles() . 'padding: 0';
        ?>
        <table class="yaymail-b2bking-offer-products td" cellspacing="0" cellpadding="6" style="<?php echo esc_attr( $table_style ); ?>" border="0" width="100%">
            <thead>
                <tr>
                    <th class="td product-title" scope="col" style="<?php echo esc_attr( $style ); ?>">
                    <?php echo esc_html( $this->titles['product'] ); ?>
                    </th>
                    <th class="td quantity-title" scope="col" style="<?php echo esc_attr( $style ); ?>">
                    <?php echo esc_html( $this->titles['quantity'] ); ?>
                    </th>
                    <th class="td price-title" scope="col" style="<?php echo esc_attr( $style ); ?>">
                    <?php echo esc_html( $this->titles['price'] ); ?>
                    </th>
                </tr>
            </thead>    
            <tbody>
                    <?php
                        $is_using_sample = ! empty( $this->sample_offer );
                    ?>
                                   
                <?php if ( $is_using_sample ) : ?>
                <tr>    
                    <td class="td product-row" scope="row" style="<?php echo esc_attr( $style ); ?>">
                        <?php echo wp_kses_post( $this->sample_offer['product'] ); ?>
                    </td>
                    <td class="td quantity-row" scope="row" style="<?php echo esc_attr( $style ); ?>">
                        <?php echo wp_kses_post( $this->sample_offer['quantity'] ); ?>
                    </td>
                    <td class="td price-row" scope="row" style="<?php echo esc_attr( $style ); ?>">
                        <?php echo wp_kses_post( $this->sample_offer['price'] ); ?>
                    </td>
                </tr>
                    <?php
                else :
                    $details        = get_post_meta( apply_filters( 'wpml_object_id', $this->offerid, 'post', true ), 'b2bking_offer_details', true );
                    $offer_products = explode( '|', $details );

                    $offer_price = 0;
                    $total_tax   = 0;
                    foreach ( $offer_products as $product ) :

                        $product_details = explode( ';', $product );
                            // if item is in the form product_id, change title
                            $isproductid = explode( '_', $product_details[0] );
                        if ( $isproductid[0] === 'product' ) {
                            // it is a product+id, get product title
                            $newproduct = wc_get_product( $isproductid[1] );

                            if ( is_a( $newproduct, 'WC_Product_Variation' ) || is_a( $newproduct, 'WC_Product' ) ) {
                                $product_details[0] = $newproduct->get_name();
                            }

                            // if product is a variation with 3 or more attributes, need to change display because get_name doesnt
                            // show items correctly
                            if ( is_a( $newproduct, 'WC_Product_Variation' ) ) {
                                $attributes           = $newproduct->get_variation_attributes();
                                $number_of_attributes = count( $attributes );
                                if ( $number_of_attributes > 2 ) {
                                    $product_details[0] .= ' - ';
                                    foreach ( $attributes as $attribute ) {
                                        $product_details[0] .= $attribute . ', ';
                                    }
                                    $product_details[0] = substr( $product_details[0], 0, -2 );
                                }
                            }
                        }//end if
                        if ( isset( $product_details[2] ) ) {
                            $unit_price_display = $product_details[2];
                        } else {
                            $unit_price_display = 1;
                            $product_details    = [];
                            $product_details[0] = 1;
                            $product_details[1] = 1;
                            $product_details[2] = 1;
                        }

                            // get offer product
                            $offerprodid   = intval( get_option( 'b2bking_offer_product_id_setting', 0 ) );
                            $offer_product = wc_get_product( $offerprodid );

                        if ( is_a( $offer_product, 'WC_Product' ) ) {
                            if ( is_a( WC()->customer, 'WC_Customer' ) ) {
                                if ( wc_prices_include_tax() && ( 'incl' !== get_option( 'woocommerce_tax_display_shop' ) || WC()->customer->is_vat_exempt() ) ) {
                                    // if prices are entered including tax, but display is without tax, remove tax
                                    // get tax rate for the offer product
                                    $tax_rates          = \WC_Tax::get_base_tax_rates( $offer_product->get_tax_class( 'unfiltered' ) );
                                    $taxes              = \WC_Tax::calc_tax( $unit_price_display, $tax_rates, true );
                                    $unit_price_display = \WC_Tax::round( $unit_price_display - array_sum( $taxes ) );

                                } elseif ( ! wc_prices_include_tax() && ( 'incl' === get_option( 'woocommerce_tax_display_shop' ) && ! WC()->customer->is_vat_exempt() ) ) {
                                    // if prices are entered excluding tax, but display is with tax, add tax
                                    $tax_rates          = \WC_Tax::get_rates( $offer_product->get_tax_class() );
                                    $taxes              = \WC_Tax::calc_tax( $unit_price_display, $tax_rates, false );
                                    $unit_price_display = \WC_Tax::round( $unit_price_display + array_sum( $taxes ) );
                                }

                                $tax_rates  = \WC_Tax::get_rates( $offer_product->get_tax_class() );
                                $taxes      = \WC_Tax::calc_tax( $unit_price_display, $tax_rates, false );
                                $total_tax += array_sum( $taxes );

                            }
                        }//end if

                            $offer_price += $unit_price_display * $product_details[1];

                        ?>
                    <tr>                    
                        <td class="td product-row" scope="row" style="<?php echo esc_attr( $style ); ?>">
                            <?php echo esc_html( strip_tags( $product_details[0] ) ); ?>
                        </td>
                        <td class="td quantity-row" scope="row" style="<?php echo esc_attr( $style ); ?>">
                            <?php echo esc_html( $product_details[1] ); ?>
                        </td>
                        <td class="td price-row" scope="row" style="<?php echo esc_attr( $style ); ?>">
                        <?php echo wp_kses_post( wc_price( $unit_price_display * $product_details[1] ) ); ?>
                        </td>
                    <tr>
                    <?php endforeach; ?>
                <?php endif; ?>
            </tbody>
            <tfoot>
            <?php if ( $is_using_sample ) : ?>
                <tr>
                    <th scope="row" colspan="2" style="<?php echo esc_attr( $style ); ?>">
                        <?php echo esc_html( $this->titles['total'] ); ?>
                    </th>
                    <td class="td" style="<?php echo esc_attr( $style ); ?>">
                        <?php echo wp_kses_post( $this->sample_offer['total'] ); ?>
                    </td>
                </tr>
                <?php else : ?>
                    <tr>
                        <th scope="row" colspan="2" style="<?php echo esc_attr( $style ); ?>">
                        <?php echo esc_html( $this->titles['total'] ); ?>
                    </th>
                    <td class="td" style="<?php echo esc_attr( $style ); ?>">
                        <?php
                        echo wp_kses_post( wc_price( $offer_price ) );
                        if ( apply_filters( 'b2bking_offer_email_display_total_with_tax', false ) ) {
                            $total_price = $offer_price += $total_tax;
                            echo wp_kses_post( ' (' . wc_price( $total_price ) . ' ' . apply_filters( 'b2bking_offer_email_total_price_tax_suffix', 'inc. VAT' ) . ')' );
                        }
                        ?>
                    </td>
                </tr>
                <?php endif; ?>
            </tfoot>
        </table>
        <?php
    }
}
