<?php

namespace YayMailAddonB2BKing\Shortcodes;

use YayMail\Abstracts\BaseShortcode;
use YayMailAddonB2BKing\SingletonTrait;
use YayMailAddonB2BKing\Emails\WcEmailB2bkingYourAccountApproved;

/**
 * @method: static B2BKingYourAccountApprovedShortcodes get_instance()
 */
class B2BKingYourAccountApprovedShortcodes extends BaseShortcode {

    use SingletonTrait;

    public function __construct() {
        $this->available_email_ids = [
            WcEmailB2bkingYourAccountApproved::get_instance()->get_id(),
        ];
        parent::__construct();
    }

    public function get_shortcodes() {
        $shortcodes   = [];
        $shortcodes[] = [
            'name'        => 'yaymail_b2bking_user_first_name',
            'description' => __( 'User First Name', 'yaymail' ),
            'group'       => 'b2bking',
            'callback'    => [ $this, 'yaymail_b2bking_user_first_name' ],
        ];
        $shortcodes[] = [
            'name'        => 'yaymail_b2bking_user_last_name',
            'description' => __( 'User Last Name', 'yaymail' ),
            'group'       => 'b2bking',
            'callback'    => [ $this, 'yaymail_b2bking_user_last_name' ],
        ];
        $shortcodes[] = [
            'name'        => 'yaymail_b2bking_user_email',
            'description' => __( 'User Email', 'yaymail' ),
            'group'       => 'b2bking',
            'callback'    => [ $this, 'yaymail_b2bking_user_email' ],
        ];

        return $shortcodes;
    }

    public function yaymail_b2bking_user_first_name( $data ) {

        $render_data = isset( $data['render_data'] ) ? $data['render_data'] : [];

        if ( ! empty( $render_data['is_sample'] ) ) {
            /**
             * Is sample order
             */
            return 'John';
        }

        if ( ! isset( $render_data['email'] ) || empty( $render_data['email']->recipient ) ) {
            /**
             * Not having email
             */

            return '';
        }
        $user       = get_user_by( 'email', $render_data['email']->recipient );
        $first_name = '';
        if ( isset( $user->ID ) ) {
            $first_name = get_user_meta( $user->ID, 'billing_first_name', true );
        }
        return $first_name;
    }

    public function yaymail_b2bking_user_last_name( $data ) {

        $render_data = isset( $data['render_data'] ) ? $data['render_data'] : [];

        if ( ! empty( $render_data['is_sample'] ) ) {
            /**
             * Is sample order
             */
            return 'Doe';
        }

        if ( ! isset( $render_data['email'] ) || empty( $render_data['email']->recipient ) ) {
            /**
             * Not having email
             */

            return '';
        }
        $user      = get_user_by( 'email', $render_data['email']->recipient );
        $last_name = '';
        if ( isset( $user->ID ) ) {
            $last_name = get_user_meta( $user->ID, 'billing_last_name', true );
        }
        return $last_name;
    }

    public function yaymail_b2bking_user_email( $data ) {

        $render_data = isset( $data['render_data'] ) ? $data['render_data'] : [];

        if ( ! empty( $render_data['is_sample'] ) ) {
            /**
             * Is sample order
             */
            return 'test@yaycommerce.com';
        }

        if ( ! isset( $render_data['email'] ) || empty( $render_data['email']->recipient ) ) {
            /**
             * Not having email
             */

            return '';
        }

        return $render_data['email']->recipient;
    }
}
