<?php

namespace YayMailAddonB2BKing\Shortcodes;

use YayMail\Abstracts\BaseShortcode;
use YayMail\Utils\TemplateHelpers;
use YayMailAddonB2BKing\SingletonTrait;
use YayMailAddonB2BKing\Emails\WcEmailB2bkingNewOffer;

/**
 * @method: static B2BKingNewOfferShortcodes get_instance()
 */
class B2BKingNewOfferShortcodes extends BaseShortcode {

    use SingletonTrait;

    public function __construct() {
        $this->available_email_ids = [
            WcEmailB2bkingNewOffer::get_instance()->get_id(),
        ];
        parent::__construct();
    }

    public function get_shortcodes() {
        $shortcodes   = [];
        $shortcodes[] = [
            'name'        => 'yaymail_b2bking_offer_link',
            'description' => __( 'Offer Link', 'yaymail' ),
            'attributes'  => [
                'text_link' => __( '-> Go to Offers', 'b2bking' ),
            ],
            'group'       => 'b2bking',
            'callback'    => [ $this, 'yaymail_b2bking_offer_link' ],
        ];
        $shortcodes[] = [
            'name'        => 'yaymail_b2bking_offer_custom_text',
            'description' => __( 'Custom text', 'yaymail' ),
            'group'       => 'b2bking',
            'callback'    => [ $this, 'yaymail_b2bking_offer_custom_text' ],
        ];
        $shortcodes[] = [
            'name'        => 'yaymail_b2bking_offer_products_title',
            'description' => __( 'Offer Products Title', 'yaymail' ),
            'group'       => 'b2bking',
            'callback'    => [ $this, 'yaymail_b2bking_offer_products_title' ],
        ];
        $shortcodes[] = [
            'name'        => 'yaymail_b2bking_offer_products',
            'description' => __( 'Offer Products Content', 'yaymail' ),
            'group'       => 'b2bking',
            'callback'    => [ $this, 'yaymail_b2bking_offer_products' ],
        ];

        return $shortcodes;
    }

    public function yaymail_b2bking_offer_link( $data, $shortcode_atts = [] ) {

        $render_data = isset( $data['render_data'] ) ? $data['render_data'] : [];

        $template = ! empty( $data['template'] ) ? $data['template'] : null;

        $text_link_color = ! empty( $template ) ? $template->get_text_link_color() : YAYMAIL_COLOR_WC_DEFAULT;

        $is_placeholder = isset( $data['is_placeholder'] ) ? $data['is_placeholder'] : false;

        $text_link = isset( $shortcode_atts['text_link'] ) ? $shortcode_atts['text_link'] : TemplateHelpers::get_content_as_placeholder( 'text_link', __( '-> Go to Offers', 'b2bking' ), $is_placeholder );

        if ( ! empty( $render_data['is_sample'] ) ) {
            /**
             * Is sample order
             */

            return '<a href="' . apply_filters( 'b2bking_offers_link', rtrim( get_permalink( wc_get_page_id( 'myaccount' ) ), '/' ) . '/' . get_option( 'b2bking_offers_endpoint_setting', 'offers' ) ) . '" style="color:' . esc_attr( $text_link_color ) . ';">' . $text_link . '</a>';
        }

        if ( empty( $render_data['offerid'] ) ) {
            /**
             * Not having offerid
             */

            return '<a href="' . apply_filters( 'b2bking_offers_link', rtrim( get_permalink( wc_get_page_id( 'myaccount' ) ), '/' ) . '/' . get_option( 'b2bking_offers_endpoint_setting', 'offers' ) ) . '" style="color:' . esc_attr( $text_link_color ) . ';">' . $text_link . '</a>';
        }

        $offers_url = apply_filters( 'b2bking_offers_link', rtrim( get_permalink( wc_get_page_id( 'myaccount' ) ), '/' ) . '/' . get_option( 'b2bking_offers_endpoint_setting', 'offers' ) );

        $offers_url = apply_filters( 'b2bking_offers_link_final', $offers_url, $render_data['offerid'] );

        return wp_kses_post( "<a style='color:$text_link_color' href='{$offers_url}'>" . $text_link . '</a>' );
    }

    public function yaymail_b2bking_offer_custom_text( $data ) {

        $render_data = isset( $data['render_data'] ) ? $data['render_data'] : [];

        if ( ! empty( $render_data['is_sample'] ) ) {
            /**
             * Is sample order
             */
            return esc_html( 'Additional custom text' );
        }

        if ( empty( $render_data['offerid'] ) ) {
            /**
             * Not having offerid
             */

            return '';
        }
        $custom_text = get_post_meta( apply_filters( 'wpml_object_id', $render_data['offerid'], 'post', true ), 'b2bking_offer_customtext_textarea', true );
        if ( ! empty( $custom_text ) && $custom_text !== null ) {
            return nl2br( $custom_text );
        }
        return '';
    }

    public function yaymail_b2bking_offer_products_title( $args ) {

        $render_data = isset( $args['render_data'] ) ? $args['render_data'] : [];

        if ( ! empty( $render_data['is_sample'] ) ) {
            /**
             * Is sample order
             */
            return '[' . __( 'Offer', 'b2bking' ) . ' #1] (' . date_i18n( wc_date_format() ) . ')';
        }

        if ( empty( $render_data['offerid'] ) ) {
            /**
             * Not having offerid
             */
            return '';
        }

        $html = yaymail_get_content( 'src/templates/shortcodes/offer-products-title/main.php', $args, YAYMAIL_ADDON_B2BKING_PLUGIN_PATH );
        return $html;
    }

    public function yaymail_b2bking_offer_products( $args ) {

        $render_data = isset( $args['render_data'] ) ? $args['render_data'] : [];

        $is_placeholder = isset( $args['is_placeholder'] ) ? $args['is_placeholder'] : false;

        if ( ! empty( $render_data['is_sample'] ) ) {
            /**
             * Is sample order
             */
            $html = yaymail_get_content( 'src/templates/shortcodes/offer-products/sample.php', $args, YAYMAIL_ADDON_B2BKING_PLUGIN_PATH );
            return $html;
        }

        $offerid = '';

        if ( isset( $render_data['offerid'] ) ) {
            $offerid = $render_data['offerid'];
        }

        if ( empty( $offerid ) && $is_placeholder ) {
            /**
             * Not having offerid
             */
            return esc_html__( 'The offer products does not have data in this order.', 'yaymail' );
        }

        if ( empty( $offerid ) && ! $is_placeholder ) {
            /**
             * Not having offerid
             */
            return '';
        }

        $args['render_data']['offerid'] = $offerid;

        $html = yaymail_get_content( 'src/templates/shortcodes/offer-products/main.php', $args, YAYMAIL_ADDON_B2BKING_PLUGIN_PATH );
        return $html;
    }
}
