<?php

namespace YayMailAddonB2BKing\Shortcodes;

use YayMail\Abstracts\BaseShortcode;
use YayMailAddonB2BKing\SingletonTrait;
use YayMailAddonB2BKing\Emails\WcEmailB2bkingNewMessage;

/**
 * @method: static B2BKingNewMessageShortcodes get_instance()
 */
class B2BKingNewMessageShortcodes extends BaseShortcode {

    use SingletonTrait;

    public function __construct() {
        $this->available_email_ids = [
            WcEmailB2bkingNewMessage::get_instance()->get_id(),
        ];
        parent::__construct();
    }

    public function get_shortcodes() {
        $shortcodes   = [];
        $shortcodes[] = [
            'name'        => 'yaymail_b2bking_new_message',
            'description' => __( 'New Message', 'yaymail' ),
            'group'       => 'b2bking',
            'callback'    => [ $this, 'yaymail_b2bking_new_message' ],
        ];
        $shortcodes[] = [
            'name'        => 'yaymail_b2bking_message',
            'description' => __( 'Message', 'yaymail' ),
            'group'       => 'b2bking',
            'callback'    => [ $this, 'yaymail_b2bking_message' ],
        ];
        return $shortcodes;
    }

    public function yaymail_b2bking_new_message( $args ) {

        $render_data = isset( $args['render_data'] ) ? $args['render_data'] : [];

        if ( ! empty( $render_data['is_sample'] ) ) {
            /**
             * Is sample order
             */
            $html = yaymail_get_content( 'src/templates/shortcodes/new-message/sample.php', $args, YAYMAIL_ADDON_B2BKING_PLUGIN_PATH );
            return $html;
        }

        if ( empty( $render_data['message'] ) ) {
            /**
             * Not having message
             */
            $html = yaymail_get_content( 'src/templates/shortcodes/new-message/sample.php', $args, YAYMAIL_ADDON_B2BKING_PLUGIN_PATH );
            return $html;
        }

        $html = yaymail_get_content( 'src/templates/shortcodes/new-message/main.php', $args, YAYMAIL_ADDON_B2BKING_PLUGIN_PATH );
        return $html;
    }

    public function yaymail_b2bking_message( $args ) {

        $render_data = isset( $args['render_data'] ) ? $args['render_data'] : [];

        if ( ! empty( $render_data['is_sample'] ) ) {
            /**
             * Is sample order
             */

            return 'message';
        }

        if ( empty( $render_data['message'] ) ) {
            return '';
        }

        $message = $render_data['message'];
        return wp_kses(
            $message,
            [
                'br' => true,
                'b'  => true,
                'a'  => [ 'href' => [] ],
            ]
        );
    }
}
