<?php

namespace YayMailAddonB2BKing\Shortcodes;

use YayMail\Abstracts\BaseShortcode;
use YayMail\Utils\TemplateHelpers;
use YayMailAddonB2BKing\SingletonTrait;
use YayMailAddonB2BKing\Emails\WcEmailB2bkingNewCustomer;
use YayMailAddonB2BKing\Emails\WcEmailB2bkingNewCustomerRequiresApproval;

/**
 * @method: static B2BKingNewCustomerShortcodes get_instance()
 */
class B2BKingNewCustomerShortcodes extends BaseShortcode {

    use SingletonTrait;

    public function __construct() {
        $this->available_email_ids = [
            WcEmailB2bkingNewCustomer::get_instance()->get_id(),
            WcEmailB2bkingNewCustomerRequiresApproval::get_instance()->get_id(),
        ];
        parent::__construct();
    }

    public function get_shortcodes() {
        $shortcodes   = [];
        $shortcodes[] = [
            'name'        => 'yaymail_b2bking_user_login',
            'description' => __( 'User Login', 'yaymail' ),
            'group'       => 'b2bking',
            'callback'    => [ $this, 'yaymail_b2bking_user_login' ],
        ];
        $shortcodes[] = [
            'name'        => 'yaymail_b2bking_user_email',
            'description' => __( 'User Email', 'yaymail' ),
            'group'       => 'b2bking',
            'callback'    => [ $this, 'yaymail_b2bking_user_email' ],
        ];
        $shortcodes[] = [
            'name'        => 'yaymail_b2bking_user_id',
            'description' => __( 'User ID', 'yaymail' ),
            'group'       => 'b2bking',
            'callback'    => [ $this, 'yaymail_b2bking_user_id' ],
        ];
        $shortcodes[] = [
            'name'        => 'yaymail_b2bking_review_user_link',
            'description' => __( 'Review User Link', 'yaymail' ),
            'attributes'  => [
                'text_link' => __( 'Click to Review User', 'b2bking' ),
            ],
            'group'       => 'b2bking',
            'callback'    => [ $this, 'yaymail_b2bking_review_user_link' ],
        ];

        return $shortcodes;
    }

    public function yaymail_b2bking_user_login( $data ) {

        $render_data = isset( $data['render_data'] ) ? $data['render_data'] : [];

        if ( ! empty( $render_data['is_sample'] ) ) {
            /**
             * Is sample order
             */
            $users = get_users(
                [
                    'number' => 1,
                ]
            );
            if ( count( $users ) > 0 ) {
                $user = $users[0];
                return $user->user_login;
            }
            return '';
        }

        if ( empty( $render_data['user_login'] ) ) {
            /**
             * Not having user_login
             */
            $users = get_users(
                [
                    'number' => 1,
                ]
            );
            if ( count( $users ) > 0 ) {
                $user = $users[0];
                return $user->user_login;
            }
            return '';
        }

        return $render_data['user_login'];
    }

    public function yaymail_b2bking_user_email( $data ) {

        $render_data = isset( $data['render_data'] ) ? $data['render_data'] : [];

        if ( ! empty( $render_data['is_sample'] ) ) {
            /**
             * Is sample order
             */
            $users = get_users(
                [
                    'number' => 1,
                ]
            );
            if ( count( $users ) > 0 ) {
                $user = $users[0];
                return $user->user_email;
            }
            return '';
        }

        if ( empty( $render_data['user_login'] ) ) {
            /**
             * Not having user_login
             */
            $users = get_users(
                [
                    'number' => 1,
                ]
            );
            if ( count( $users ) > 0 ) {
                $user = $users[0];
                return $user->user_email;
            }
            return '';
        }
        $user = get_user_by( 'login', $render_data['user_login'] );
        return $user->user_email;
    }

    public function yaymail_b2bking_user_id( $data ) {

        $render_data = isset( $data['render_data'] ) ? $data['render_data'] : [];

        if ( ! empty( $render_data['is_sample'] ) ) {
            /**
             * Is sample order
             */
            return '1';
        }

        if ( empty( $render_data['user_login'] ) ) {
            /**
             * Not having user_login
             */
            $users = get_users(
                [
                    'number' => 1,
                ]
            );
            if ( count( $users ) > 0 ) {
                $user = $users[0];
                return $user->ID;
            }
            return '';
        }
        $user_login = $render_data['user_login'];
        $user       = get_user_by( 'login', $user_login );
        return $user->ID;
    }

    public function yaymail_b2bking_review_user_link( $data, $shortcode_atts = [] ) {

        $render_data = isset( $data['render_data'] ) ? $data['render_data'] : [];

        $template = ! empty( $data['template'] ) ? $data['template'] : null;

        $text_link_color = ! empty( $template ) ? $template->get_text_link_color() : YAYMAIL_COLOR_WC_DEFAULT;

        $is_placeholder = isset( $data['is_placeholder'] ) ? $data['is_placeholder'] : false;

        $text_link = isset( $shortcode_atts['text_link'] ) ? $shortcode_atts['text_link'] : TemplateHelpers::get_content_as_placeholder( 'text_link', __( 'Click to Review User', 'b2bking' ), $is_placeholder );

        if ( ! empty( $render_data['is_sample'] ) ) {
            /**
             * Is sample order
             */
            $users = get_users(
                [
                    'number' => 1,
                ]
            );
            $user  = $users[0];
            return '<a href="' . admin_url( '/user-edit.php?user_id=' . $user->ID . '#b2bking_registration_data_container' ) . '" style="color:' . esc_attr( $text_link_color ) . ';">' . $text_link . '</a>';
        }

        if ( empty( $render_data['user_login'] ) ) {
            /**
             * Not having user_login
             */
            $users = get_users(
                [
                    'number' => 1,
                ]
            );
            $user  = $users[0];
            return '<a href="' . admin_url( '/user-edit.php?user_id=' . $user->ID . '#b2bking_registration_data_container' ) . '" style="color:' . esc_attr( $text_link_color ) . ';">' . $text_link . '</a>';
        }
        $user = get_user_by( 'login', $render_data['user_login'] );

        $review_user_url = admin_url( '/user-edit.php?user_id=' . $user->ID . '#b2bking_registration_data_container' );

        return wp_kses_post( "<a style='color:$text_link_color' href='{$review_user_url}'>" . $text_link . '</a>' );
    }
}
