<?php

namespace YayMailAddonB2BKing\Migrations\Versions;

use YayMail\Migrations\AbstractMigration;
use YayMailAddonB2BKing\SingletonTrait;
use YayMailAddonB2BKing\Migrations\B2BKingMigration;
/**
 * B2BKing_Ver_2_0_0 Class
 *
 * @method static B2BKing_Ver_2_0_0 get_instance()
 */
final class B2BKing_Ver_2_0_0 extends AbstractMigration {
    use SingletonTrait;

    private function __construct() {
        parent::__construct( '1.5.0', '4.0', 'YayMailAddonB2BKing' );
    }

    protected function up() {
        global $wpdb;
        $template_posts_query = "
            SELECT * 
            FROM {$wpdb->posts}
            WHERE post_type = 'yaymail_template'
        ";
        $template_posts       = $wpdb->get_results( $template_posts_query );
        if ( empty( $template_posts ) ) {
            $this->logger->log( 'There is no template to be migrated' );
            return;
        }
        foreach ( $template_posts as $template ) {
            $template_id = $template->ID;
            $elements    = get_post_meta( $template_id, '_yaymail_elements', true );

            $this->migrate_elements( $elements, $template );

            update_post_meta( $template_id, '_yaymail_elements', $elements );
            $this->may_mark_template_as_v4_supported( $template_id, B2BKingMigration::get_instance() );
        }
    }

    private function migrate_elements( &$elements, $template ) {
        foreach ( $elements as $key => &$element ) {
            if ( $element['type'] === 'AddonB2BKingInformation' ) {
                $element['name']              = __( 'Offer Products', 'yaymail' );
                $element['type']              = 'addon_b2bking_offer_products';
                $element['data']['title']     = '[yaymail_b2bking_offer_products_title]';
                $element['data']['rich_text'] = '[yaymail_b2bking_offer_products]';
                $this->set_elements_common_data( $element );
            }
        }

        foreach ( $elements as $key => &$element ) {
            $this->migrate_shortcodes( $element['data'] );
        }
    }

    private function migrate_shortcodes( &$data ) {
        foreach ( $data as $key => &$value ) {
            if ( is_array( $value ) ) {
                $this->migrate_shortcodes( $value );
                continue;
            }

            $new_shortcodes_content = [
                'template_new_customer'          => '<p><span>' . __( 'You have a new customer registration.', 'b2bking' ) . '<br /><br /></span></p><p><span>' . __( 'Username:', 'b2bking' ) . ' [yaymail_b2bking_user_login]<br /><br /></span></p><p><span>' . __( 'Email:', 'b2bking' ) . ' [yaymail_b2bking_user_email]</span></p>',
                'template_new_customer_approval' => '<p><span>' . __( 'You have a new customer registration that requires approval.', 'b2bking' ) . '<br /><br /></span></p><p><span>' . __( 'Username:', 'b2bking' ) . ' [yaymail_b2bking_user_login]<br /><br /></span></p><p><span>' . __( 'Email:', 'b2bking' ) . ' [yaymail_b2bking_user_email]<br /><br /></span></p><p><span>[yaymail_b2bking_review_user_link]</span></p>',
            ];

            $shortcodes_map = [
                // '[old' => '[new]'
                '[yaymail_addon_new_customer_user_login]' => '[yaymail_b2bking_user_login]',
                '[yaymail_addon_new_customer_user_email]' => '[yaymail_b2bking_user_email]',
                '[yaymail_addon_new_customer_user_id]'    => '[yaymail_b2bking_user_id]',
                '[yaymail_addon_template_new_message]'    => '[yaymail_b2bking_new_message]',
                '[yaymail_addon_template_new_message_request]' => '[yaymail_b2bking_message]',
                '[yaymail_addon_b2bking_account_approved_first_name]' => '[yaymail_b2bking_user_first_name]',
                '[yaymail_addon_b2bking_account_approved_last_name]' => '[yaymail_b2bking_user_last_name]',
                '[yaymail_addon_b2bking_account_approved_email]' => '[yaymail_b2bking_user_email]',
                '[yaymail_addon_template_new_customer]'   => $new_shortcodes_content['template_new_customer'],
                '[yaymail_addon_template_new_customer_approval]' => $new_shortcodes_content['template_new_customer_approval'],
            ];

            foreach ( $shortcodes_map as $old => $new ) {

                $value = str_replace( $old, $new, $value );
            }
        }//end foreach
    }

    private function set_elements_common_data( &$element ) {
        if ( isset( $element['settingRow']['titleProduct'] ) ) {
            $element['data']['product_title'] = $element['settingRow']['titleProduct'];
        }

        if ( isset( $element['settingRow']['titleQuantity'] ) ) {
            $element['data']['quantity_title'] = $element['settingRow']['titleQuantity'];
        }

        if ( isset( $element['settingRow']['titlePrice'] ) ) {
            $element['data']['price_title'] = $element['settingRow']['titlePrice'];
        }

        if ( isset( $element['settingRow']['titleTotal'] ) ) {
            $element['data']['total_title'] = $element['settingRow']['titleTotal'];
        }
    }
}
