<?php
namespace YayMailAddonB2BKing\Migrations;

use YayMail\Migrations\AbstractAddonMigrationManager;
use YayMail\Migrations\MigrationHelper;
use YayMail\Utils\Logger;
use YayMailAddonB2BKing\SingletonTrait;


/**
 * B2BKingMigration Class
 *
 * @method static B2BKingMigration get_instance()
 */
class B2BKingMigration extends AbstractAddonMigrationManager {
    use SingletonTrait;


    protected function __construct() {
        $this->default_legacy_version = '1.9.9';
        $addon_versions               = get_option( 'yaymail_addon_versions' );
        $old_version                  = MigrationHelper::format_version_number( $addon_versions['YayMailAddonB2BKing'] ?? $this->default_legacy_version );

        parent::__construct( $old_version, YAYMAIL_ADDON_B2BKING_VERSION, 'YayMailAddonB2BKing', __( 'YayMail Addon For B2BKing', 'yaymail' ) );
    }

    protected function declare_migrations() {
        $this->addon_migrations = [
            '4.0' => 'YayMailAddonB2BKing\Migrations\Versions\B2BKing_Ver_2_0_0',
        ];
    }

    protected function filter_migrations_by_v4_supported_status(): void {
        $this->filter_migrations_by_version_threshold( '4.0' );
    }
}
