<?php

namespace YayMailAddonB2BKing\Emails;

use YayMail\Abstracts\BaseEmail;
use YayMail\Elements\ElementsLoader;
use YayMailAddonB2BKing\SingletonTrait;

/**
 * WcEmailB2bkingYourAccountApproved Class
 *
 * @method static WcEmailB2bkingYourAccountApproved get_instance()
 */
class WcEmailB2bkingYourAccountApproved extends BaseEmail {
    use SingletonTrait;

    public $email_types = [ YAYMAIL_NON_ORDER_EMAILS ];

    protected function __construct() {
        $emails = \WC_Emails::instance()->get_emails();
        if ( ! isset( $emails['B2bking_Your_Account_Approved_Email'] ) ) {
            return;
        }
        $email           = $emails['B2bking_Your_Account_Approved_Email'];
        $this->id        = $email->id;
        $this->title     = $email->get_title();
        $this->recipient = $email->is_customer_email() ? __( 'Customer', 'woocommerce' ) : __( 'Admin', 'woocommerce' );
        $this->source    = [
            'plugin_id'   => 'b2bking',
            'plugin_name' => 'B2BKing',
        ];

        add_filter( 'wc_get_template', [ $this, 'get_template_file' ], 10, 3 );
    }

    public function get_default_elements() {
        $email_title      = __( 'Your account has been approved', 'b2bking' );
        $email_hi         = __( 'Hi', 'b2bking' );
        $email_text       = __( 'Congratulations! Your account has been approved.', 'b2bking' );
        $default_elements = ElementsLoader::load_elements(
            [
                [
                    'type' => 'Logo',
                ],
                [
                    'type'       => 'Heading',
                    'attributes' => [
                        'rich_text' => $email_title,
                    ],
                ],
                [
                    'type'       => 'Text',
                    'attributes' => [
                        'rich_text' => '<p><span>' . $email_hi . ' [yaymail_b2bking_user_first_name]<br /><br /></span></p><p><span>' . $email_text . '</span></p>',
                    ],
                ],
                [
                    'type' => 'Footer',
                ],
            ]
        );

        return $default_elements;
    }

    public function get_template_path() {
        return YAYMAIL_ADDON_B2BKING_PLUGIN_PATH . 'src/templates/emails/wc-email-b2bking-your-account-approved.php';
    }
}
