<?php

namespace YayMailAddonB2BKing\Emails;

use YayMail\Abstracts\BaseEmail;
use YayMail\Elements\ElementsLoader;
use YayMailAddonB2BKing\SingletonTrait;

/**
 * WcEmailB2bkingNewMessage Class
 *
 * @method static WcEmailB2bkingNewMessage get_instance()
 */
class WcEmailB2bkingNewMessage extends BaseEmail {
    use SingletonTrait;

    public $email_types = [ YAYMAIL_NON_ORDER_EMAILS ];

    protected function __construct() {
        $emails = \WC_Emails::instance()->get_emails();
        if ( ! isset( $emails['B2bking_New_Message_Email'] ) ) {
            return;
        }
        $email           = $emails['B2bking_New_Message_Email'];
        $this->id        = $email->id;
        $this->title     = $email->get_title();
        $this->recipient = $email->is_customer_email() ? __( 'Customer', 'woocommerce' ) : __( 'Admin', 'woocommerce' );
        $this->source    = [
            'plugin_id'   => 'b2bking',
            'plugin_name' => 'B2BKing',
        ];

        add_filter( 'wc_get_template', [ $this, 'get_template_file' ], 10, 3 );
    }

    public function get_default_elements() {
        $email_title      = __( 'New message / conversation', 'b2bking' );
        $default_elements = ElementsLoader::load_elements(
            [
                [
                    'type' => 'Logo',
                ],
                [
                    'type'       => 'Heading',
                    'attributes' => [
                        'rich_text' => $email_title,
                    ],
                ],
                [
                    'type'       => 'Text',
                    'attributes' => [
                        'rich_text' => '<p><span>[yaymail_b2bking_new_message]</span></p>',
                    ],
                ],
                [
                    'type' => 'Footer',
                ],
            ]
        );

        return $default_elements;
    }

    public function get_template_path() {
        return YAYMAIL_ADDON_B2BKING_PLUGIN_PATH . 'src/templates/emails/wc-email-b2bking-new-message.php';
    }
}
