<?php

namespace YayMailAddonB2BKing\Elements;

use YayMailAddonB2BKing\SingletonTrait;

/**
 * Email Loader Class
 *
 * @method static ElementsLoader get_instance()
 */
class ElementsLoader {
    use SingletonTrait;

    private function __construct() {
        add_action( 'yaymail_register_elements', [ $this, 'register_elements' ] );
    }

    public function register_elements( $service ) {
        $dir = new \DirectoryIterator( YAYMAIL_ADDON_B2BKING_PLUGIN_PATH . '/src/Elements' );
        foreach ( $dir as $fileinfo ) {
            if ( ! $fileinfo->isDot() ) {
                $file_name  = $fileinfo->getFilename();
                $class_name = basename( $file_name, '.php' );
                $class      = 'YayMailAddonB2BKing\\Elements\\' . $class_name;
                if ( __CLASS__ === $class ) {
                    continue;
                }
                if ( class_exists( $class ) ) {
                    $service->register_element( $class::get_instance() );
                }
            }
        }
    }

}
