<?php
namespace YayMailAddonB2BKing\Elements;

use YayMail\Abstracts\BaseElement;
use YayMail\Elements\ElementsHelper;
use YayMailAddonB2BKing\SingletonTrait;
use YayMailAddonB2BKing\Emails\WcEmailB2bkingNewOffer;

/**
 * Offer Products
 */
class AddonB2BKingOfferProducts extends BaseElement {

    use SingletonTrait;

    protected static $type = 'addon_b2bking_offer_products';

    protected function __construct() {
        $this->available_email_ids = [
            WcEmailB2bkingNewOffer::get_instance()->get_id(),
        ];
    }

    public static function get_data( $attributes = [] ) {
        self::$icon = YAYMAIL_EXTRA_ELEMENT_ICON;

        return [
            'id'              => uniqid(),
            'type'            => self::$type,
            'name'            => __( 'Offer Products', 'yaymail' ),
            'icon'            => self::$icon,
            'group'           => 'woocommerce',
            'position'        => 250,
            'available'       => true,
            'addon_namespace' => 'YayMailAddonB2BKing',
            'data'            => [
                'padding'          => ElementsHelper::get_spacing( $attributes ),
                'background_color' => ElementsHelper::get_color(
                    $attributes,
                    [
                        'default_value' => '#fff',
                    ]
                ),
                'title_color'      => ElementsHelper::get_color(
                    $attributes,
                    [
                        'value_path'    => 'title_color',
                        'title'         => __( 'Title color', 'yaymail' ),
                        'default_value' => YAYMAIL_COLOR_WC_DEFAULT,
                    ]
                ),
                'text_color'       => ElementsHelper::get_color(
                    $attributes,
                    [
                        'value_path'    => 'text_color',
                        'title'         => __( 'Text color', 'yaymail' ),
                        'default_value' => YAYMAIL_COLOR_TEXT_DEFAULT,
                    ]
                ),
                'border_color'     => ElementsHelper::get_color(
                    $attributes,
                    [
                        'value_path'    => 'border_color',
                        'title'         => __( 'Border color', 'yaymail' ),
                        'default_value' => YAYMAIL_COLOR_BORDER_DEFAULT,
                    ]
                ),
                'font_family'      => ElementsHelper::get_font_family_selector( $attributes ),
                'product_title'    => ElementsHelper::get_text_input(
                    $attributes,
                    [
                        'value_path'    => 'product_title',
                        'title'         => __( 'Product title', 'yaymail' ),
                        'default_value' => __( 'Product', 'b2bking' ),
                    ]
                ),
                'quantity_title'   => ElementsHelper::get_text_input(
                    $attributes,
                    [
                        'value_path'    => 'quantity_title',
                        'title'         => __( 'Quantity title', 'yaymail' ),
                        'default_value' => __( 'Quantity', 'b2bking' ),
                    ]
                ),
                'price_title'      => ElementsHelper::get_text_input(
                    $attributes,
                    [
                        'value_path'    => 'price_title',
                        'title'         => __( 'Price title', 'yaymail' ),
                        'default_value' => __( 'Price', 'b2bking' ),
                    ]
                ),
                'total_title'      => ElementsHelper::get_text_input(
                    $attributes,
                    [
                        'value_path'    => 'total_title',
                        'title'         => __( 'Total title', 'yaymail' ),
                        'default_value' => __( 'Total', 'b2bking' ),
                    ]
                ),
                'title'            => [
                    'value_path'    => 'title',
                    'component'     => '',
                    'title'         => __( 'Title', 'yaymail' ),
                    'default_value' => '[yaymail_b2bking_offer_products_title]',
                    'type'          => 'content',
                ],
                'rich_text'        => [
                    'value_path'    => 'rich_text',
                    'component'     => '',
                    'title'         => __( 'Content', 'yaymail' ),
                    'default_value' => '[yaymail_b2bking_offer_products]',
                    'type'          => 'content',
                ],
            ],
        ];
    }

    public static function get_layout( $element, $args ) {
        $path = 'src/templates/elements/offer-products.php';
        return yaymail_get_content( $path, array_merge( [ 'element' => $element ], $args ), YAYMAIL_ADDON_B2BKING_PLUGIN_PATH );
    }
}
