<?php

namespace YayMailAddonB2BKing\Controllers;

use YayMailAddonB2BKing\SingletonTrait;
use YayMailAddonB2BKing\Elements\ElementsLoader;
use YayMailAddonB2BKing\Migrations\B2BKingMigration;

defined( 'ABSPATH' ) || exit;

/**
 * AddonController Class
 *
 * @method static AddonController get_instance()
 */
class AddonController {

    use SingletonTrait;

    protected function __construct() {
        B2BKingMigration::get_instance();
        ElementsLoader::get_instance();
        add_action( 'yaymail_register_emails', [ $this, 'register_emails' ] );
        add_action( 'yaymail_register_shortcodes', [ $this, 'yaymail_addon_shortcode_defined' ] );
    }

    public function yaymail_addon_shortcode_defined( $shortcode_service ) {
        \YayMailAddonB2BKing\Shortcodes\B2BKingNewCustomerShortcodes::get_instance();
        \YayMailAddonB2BKing\Shortcodes\B2BKingYourAccountApprovedShortcodes::get_instance();
        \YayMailAddonB2BKing\Shortcodes\B2BKingNewMessageShortcodes::get_instance();
        \YayMailAddonB2BKing\Shortcodes\B2BKingNewOfferShortcodes::get_instance();
    }

    public function register_emails( $yaymail_emails ) {
        $yaymail_emails->register( \YayMailAddonB2BKing\Emails\WcEmailB2bkingNewCustomer::get_instance() );
        $yaymail_emails->register( \YayMailAddonB2BKing\Emails\WcEmailB2bkingNewCustomerRequiresApproval::get_instance() );
        $yaymail_emails->register( \YayMailAddonB2BKing\Emails\WcEmailB2bkingYourAccountApproved::get_instance() );
        $yaymail_emails->register( \YayMailAddonB2BKing\Emails\WcEmailB2bkingNewMessage::get_instance() );
        $yaymail_emails->register( \YayMailAddonB2BKing\Emails\WcEmailB2bkingNewOffer::get_instance() );
    }
}
